PrefabFiles = {
    "niaoniao",
    "potted_boardleaf",
    "potted_boardleaf_burnt",
    "ghost_orchid_seed",
    "ghost_orchid",
}

-- 引入通用放置器，我打算使用官方的放置器
modimport("scripts/universal_placer.lua")

-- 初始化通用放置器
local UniversalPlacer = GLOBAL.require("universal_placer")
local up = UniversalPlacer()

-- 移除这些Asset声明，直接使用游戏内置动画
Assets = {
    --用于主菜单的存档槽中显示的角色小头像。
    Asset( "IMAGE", "images/saveslot_portraits/niaoniao.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/niaoniao.xml" ),

    --选择屏幕肖像（selectscreen_portraits）: 用于角色选择界面的正常头像。  
    Asset( "IMAGE", "images/selectscreen_portraits/niaoniao.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/niaoniao.xml" ),

	--选择屏幕肖像剪影（selectscreen_portraits_silho）: 用于角色选择界面当角色未解锁时的剪影。应该是审视自我界面的。
    Asset( "IMAGE", "images/selectscreen_portraits/niaoniao_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/niaoniao_silho.xml" ),

    --角色肖像。
    Asset( "IMAGE", "bigportraits/niaoniao.tex" ),
    Asset( "ATLAS", "bigportraits/niaoniao.xml" ),

	--地图上的头像。
	Asset( "IMAGE", "images/map_icons/niaoniao.tex" ),
	Asset( "ATLAS", "images/map_icons/niaoniao.xml" ),

	--头像（avatars）: 用于游戏内的对话头像（如说话时显示的头像）。
	Asset( "IMAGE", "images/avatars/avatar_niaoniao.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_niaoniao.xml" ),

	--幽灵头像（avatar_ghost）: 角色死亡变成幽灵时显示的头像。
	Asset( "IMAGE", "images/avatars/avatar_ghost_niaoniao.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_niaoniao.xml" ),

	--自我审视的黑标。
	Asset( "IMAGE", "images/avatars/self_inspect_niaoniao.tex" ),
    Asset( "ATLAS", "images/avatars/self_inspect_niaoniao.xml" ),

	--进入游戏选角色的艺术名字。
	Asset( "IMAGE", "images/names_niaoniao.tex" ),
    Asset( "ATLAS", "images/names_niaoniao.xml" ),
    
	--进入游戏选角色的金色艺术名字。
	Asset( "IMAGE", "images/names_gold_niaoniao.tex" ),
    Asset( "ATLAS", "images/names_gold_niaoniao.xml" ),

    --板叶盆制作。
    Asset("ATLAS", "images/inventoryimages/potted_boardleaf.xml"),
    Asset("IMAGE", "images/inventoryimages/potted_boardleaf.tex"),

    --水晶兰的种子和植物。
    Asset("ANIM", "anim/ghost_orchid.zip"),
    --Asset("ANIM", "anim/ghost_orchid_seed.zip"),
    Asset("ATLAS", "images/inventoryimages/ghost_orchid_seed.xml"),
    Asset("IMAGE", "images/inventoryimages/ghost_orchid_seed.tex"),
}

-- 如果你没有自定义地图图标，也移除这一行
AddMinimapAtlas("images/map_icons/niaoniao.xml")

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local RECIPETABS = GLOBAL.RECIPETABS
local TECH = GLOBAL.TECH
local CHARACTER_TAG = "niaoniao"

-- 角色文本
STRINGS.CHARACTER_TITLES.niaoniao = "嗜睡的精灵"
STRINGS.CHARACTER_NAMES.niaoniao = "袅袅"
STRINGS.CHARACTER_DESCRIPTIONS.niaoniao = "*一只误入永恒领域的小精灵\n*蝴蝶亲和，不会吓跑小动物\n*似乎拥有强大的睡眠魔法..."
STRINGS.CHARACTER_QUOTES.niaoniao = "\"我想我又困了...\""
STRINGS.CHARACTER_SURVIVABILITY.niaoniao = "正常"

-- Custom speech strings
STRINGS.CHARACTERS.niaoniao = GLOBAL.STRINGS.CHARACTERS.WILSON

-- The character's name as appears in-game 
STRINGS.NAMES.niaoniao = "袅袅"
STRINGS.SKIN_NAMES.niaoniao_none = "袅袅"

-- 皮肤设置
local skin_modes = {
    { 
        type = "ghost_skin",
        anim_bank = "ghost",
        idle_anim = "idle", 
        scale = 0.75, 
        offset = { 0, -25 } 
    },
}

-- 添加mod角色
AddModCharacter("niaoniao", "FEMALE", skin_modes)

--universal_placer的用法，与其他mod可能不兼容

--板叶盆科技。
-- 字符串设置
STRINGS.NAMES.POTTED_BOARDLEAF = "板叶盆"
STRINGS.RECIPE_DESC.POTTED_BOARDLEAF = "不错的盆栽"
GLOBAL.STRINGS.NAMES.POTTED_BOARDLEAF_BURNT = "板叶盆"
GLOBAL.STRINGS.RECIPE_DESC.POTTED_BOARDLEAF_BURNT = "烧毁的板叶盆"

-- 在modmain.lua中添加角色对话
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.POTTED_BOARDLEAF = "一个装饰性的板叶盆栽。"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.POTTED_BOARDLEAF_BURNT = "哦不，它被烧毁了。"

-- 角色专属对话 - 安全地初始化所有角色表
local function SafeDescribe(character, description, burnt_description)
    GLOBAL.STRINGS.CHARACTERS[character] = GLOBAL.STRINGS.CHARACTERS[character] or {}
    GLOBAL.STRINGS.CHARACTERS[character].DESCRIBE = GLOBAL.STRINGS.CHARACTERS[character].DESCRIBE or {}
    GLOBAL.STRINGS.CHARACTERS[character].DESCRIBE.POTTED_BOARDLEAF = description
    GLOBAL.STRINGS.CHARACTERS[character].DESCRIBE.POTTED_BOARDLEAF_BURNT = burnt_description or "它被烧毁了。"
end

-- 添加所有角色的对话（正常状态和烧毁状态）
SafeDescribe("WILSON", "科学证明植物有助于改善心情。", "科学也无法拯救被烧毁的植物。")
SafeDescribe("WILLOW", "至少这个不会着火。", "好吧，看来我说错了。")
SafeDescribe("WOLFGANG", "小盆栽让沃尔夫冈感到平静。", "现在它只让沃尔夫冈感到悲伤。")
SafeDescribe("WENDY", "生命的脆弱美丽，终将凋零。", "凋零来得比预期更早。")
SafeDescribe("WX78", "无用的有机装饰物", "现在连装饰作用都没有了")
SafeDescribe("WICKERBOTTOM", "这种栽培方式有助于植物光合作用。", "高温破坏了植物的细胞结构。")
SafeDescribe("WOODIE", "嘿，不错的木工活儿。", "木头部分也烧焦了，真可惜。")
SafeDescribe("WAXWELL", "至少比那些粗糙的工艺品好看。", "现在它和那些粗糙工艺品一样难看了。")
SafeDescribe("WIGFRID", "战火中的一丝宁静。", "战火最终吞噬了这份宁静。")
SafeDescribe("WEBBER", "我们想在里面养只小虫子！", "现在连虫子都不愿意住这里了。")
SafeDescribe("WINONA", "结实的工艺，能用很久。", "再结实的工艺也抵不过火焰。")
SafeDescribe("WARLY", "也许可以种些香草？", "现在只能闻到焦糊味了。")
SafeDescribe("WORTOX", "小精灵喜欢这个小盆子！", "小精灵不喜欢烧焦的东西！")
SafeDescribe("WALTER", "沃比说它很漂亮！", "沃比为它感到难过。")
SafeDescribe("WANDA", "时间在这上面流逝得很平静。", "时间在这里加速了燃烧过程。")
SafeDescribe("WURT", "适合放在我的沼泽家里。", "烧焦的东西不适合沼泽。")
SafeDescribe("WORMWOOD", "小植物会开心！", "小植物不开心...")

-- 自定义角色袅袅的对话（随机选择）
SafeDescribe("niaoniao", {
    "这是我亲手制作的板叶盆...",
    "希望这些叶子能长得更好...",
}, {
    "也许我该重新做一个..."
})

-- 创建并注册 placer 预制体
local potted_boardleaf_placer = up:CreateStructurePlacer("potted_boardleaf", "entity", "potted_boardleaf", "potted_boardleaf_idle", {
    snap_to_tile = false,
    snap_to_water = false
})

-- 将创建的 placer 添加到游戏
GLOBAL.Prefabs["potted_boardleaf_placer"] = potted_boardleaf_placer

-- 直接使用游戏内置的角色专属分类
local recipe = AddRecipe2("potted_boardleaf", 
    { 
        Ingredient("foliage", 2), 
        Ingredient("cutstone", 1) 
    },
    TECH.SCIENCE_ONE,
    {
        atlas = "images/inventoryimages/potted_boardleaf.xml",
        image = "potted_boardleaf.tex",
        placer = "potted_boardleaf_placer",
        --builder_tag = "niaoniao", 全角色通用
    },
    {"DECOR"}
)

recipe.sortkey = 1

-- 水晶兰科技
-- 添加字符串定义
GLOBAL.STRINGS.NAMES.GHOST_ORCHID_SEED = "水晶兰种子"
GLOBAL.STRINGS.RECIPE_DESC.GHOST_ORCHID_SEED = "神秘的水晶兰种子"

GLOBAL.STRINGS.NAMES.GHOST_ORCHID_STAGE1 = "水晶兰幼苗"
GLOBAL.STRINGS.NAMES.GHOST_ORCHID_TRANSITION = "生长的水晶兰"
GLOBAL.STRINGS.NAMES.GHOST_ORCHID_STAGE2 = "水晶兰"
GLOBAL.STRINGS.NAMES.GHOST_ORCHID_STAGE3 = "盛开的水晶兰"

-- 设置激活交互文本
if not STRINGS.ACTIONS then
    STRINGS.ACTIONS = {}
end

STRINGS.ACTIONS.ACTIVATE = STRINGS.ACTIONS.ACTIVATE or {}
STRINGS.ACTIONS.ACTIVATE.GHOST_ORCHID = "复活"

-- 复活来源字符串设置
GLOBAL.STRINGS.UI.HUD.GHOST_ORCHID_RESURRECTION = "水晶兰"
if not GLOBAL.STRINGS.UI.HUD.RESURRECTION_SOURCE then
    GLOBAL.STRINGS.UI.HUD.RESURRECTION_SOURCE = {}
end
GLOBAL.STRINGS.UI.HUD.RESURRECTION_SOURCE.ghost_orchid = "水晶兰"

-- 通用描述文本
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.GHOST_ORCHID_SEED = "一颗神秘的种子，散发着微弱的光芒。"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.GHOST_ORCHID_STAGE1 = "它似乎渴望着某种养分"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.GHOST_ORCHID_TRANSITION = "它正在慢慢生长..."
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.GHOST_ORCHID_STAGE2 = "它异常的精灵古怪"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.GHOST_ORCHID_STAGE3 = "它散发着强大的生命能量！可以复活幽灵！"

-- 角色专属对话函数
local function SafeDescribeGhostOrchid(character, descriptions)
    GLOBAL.STRINGS.CHARACTERS[character] = GLOBAL.STRINGS.CHARACTERS[character] or {}
    GLOBAL.STRINGS.CHARACTERS[character].DESCRIBE = GLOBAL.STRINGS.CHARACTERS[character].DESCRIBE or {}
    
    for name, desc in pairs(descriptions) do
        GLOBAL.STRINGS.CHARACTERS[character].DESCRIBE[name] = desc
    end
end

-- 各角色对水晶兰的描述
SafeDescribeGhostOrchid("WILSON", {
    GHOST_ORCHID_SEED = "这颗种子的生物特征很独特，值得研究。",
    GHOST_ORCHID_STAGE1 = "这种植物需要特殊的养分才能生长。",
    GHOST_ORCHID_TRANSITION = "它在慢慢吸收营养，逐渐成长。",
    GHOST_ORCHID_STAGE2 = "它在吸收周围的精神能量！需要小心。",
    GHOST_ORCHID_STAGE3 = "惊人的生命力！似乎贯通了生死。"
})

SafeDescribeGhostOrchid("WILLOW", {
    GHOST_ORCHID_SEED = "它看起来不会燃烧，真可惜。",
    GHOST_ORCHID_STAGE1 = "它饥饿的想吃下我打火机里的火焰",
    GHOST_ORCHID_TRANSITION = "它在慢慢燃烧...我是说生长",
    GHOST_ORCHID_STAGE2 = "它令伯尼躁动",
    GHOST_ORCHID_STAGE3 = "这算是它欠的利息吗"
})

SafeDescribeGhostOrchid("WOLFGANG", {
    GHOST_ORCHID_SEED = "小种子，能种出大植物吗？",
    GHOST_ORCHID_STAGE1 = "它不吃土豆，它更想吃我",
    GHOST_ORCHID_TRANSITION = "它在变得强壮！",
    GHOST_ORCHID_STAGE2 = "我不想靠这么近，我害怕...",
    GHOST_ORCHID_STAGE3 = "现在看起来跟土豆的价值不相上下了"
})

SafeDescribeGhostOrchid("WENDY", {
    GHOST_ORCHID_SEED = "死亡的芬芳从这颗种子中散发出来。",
    GHOST_ORCHID_STAGE1 = "它渴望与死亡相关的养分...",
    GHOST_ORCHID_TRANSITION = "生命的能量正在缓慢流动...",
    GHOST_ORCHID_STAGE2 = "阿比盖尔说它在收集生命的能量。", 
    GHOST_ORCHID_STAGE3 = "生与死的界限在此变得模糊..."
})

SafeDescribeGhostOrchid("WX78", {
    GHOST_ORCHID_SEED = "低效的生物繁殖方式",
    GHOST_ORCHID_STAGE1 = "非逻辑的生物需求模式",
    GHOST_ORCHID_TRANSITION = "检测到缓慢的生物质积累",
    GHOST_ORCHID_STAGE2 = "检测到异常精神能量吸收", 
    GHOST_ORCHID_STAGE3 = "高效的生命维持系统"
})

SafeDescribeGhostOrchid("WICKERBOTTOM", {
    GHOST_ORCHID_SEED = "这种子不符合任何已知的植物分类。",
    GHOST_ORCHID_STAGE1 = "生产者代替消费者算是个例了",
    GHOST_ORCHID_TRANSITION = "光合作用似乎不是它主要的能量来源",
    GHOST_ORCHID_STAGE2 = "带在旁边可真影响阅读",
    GHOST_ORCHID_STAGE3 = "它现在极具活性"
})

SafeDescribeGhostOrchid("WOODIE", {
    GHOST_ORCHID_SEED = "路易斯说这颗种子很特别。",
    GHOST_ORCHID_STAGE1 = "从来都是我主宰植物，对吧？",
    GHOST_ORCHID_TRANSITION = "路易斯说它在悄悄长大",
    GHOST_ORCHID_STAGE2 = "路易，你得安静点",
    GHOST_ORCHID_STAGE3 = "欠我的思绪就这么还吗？"
})

SafeDescribeGhostOrchid("WAXWELL", {
    GHOST_ORCHID_SEED = "这颗种子有着不同寻常的优雅。",
    GHOST_ORCHID_STAGE1 = "我真后悔没有在后花园种这个",
    GHOST_ORCHID_TRANSITION = "优雅的蜕变过程",
    GHOST_ORCHID_STAGE2 = "查理一定很喜欢，现在也一定是。",
    GHOST_ORCHID_STAGE3 = "我们算是双赢吗"
})

SafeDescribeGhostOrchid("WIGFRID", {
    GHOST_ORCHID_SEED = "这颗种子蕴含着强大的生命力！",
    GHOST_ORCHID_STAGE1 = "小植物，你有着跟我一样凶猛的口味！",
    GHOST_ORCHID_TRANSITION = "你在为战斗做准备吗？",
    GHOST_ORCHID_STAGE2 = "你里面藏着什么怪物",
    GHOST_ORCHID_STAGE3 = "真正的战士难道要让要让一朵花来保护吗？"
})

SafeDescribeGhostOrchid("WEBBER", {
    GHOST_ORCHID_SEED = "我们想把它种在我们的花园里！",
    GHOST_ORCHID_STAGE1 = "它的兴趣是什么？",
    GHOST_ORCHID_TRANSITION = "它在慢慢变化呢",
    GHOST_ORCHID_STAGE2 = "好漂亮，但是好可怕",
    GHOST_ORCHID_STAGE3 = "如果我可以把它送给妈妈..."
})

SafeDescribeGhostOrchid("WINONA", {
    GHOST_ORCHID_SEED = "这颗种子看起来不需要修理。",
    GHOST_ORCHID_STAGE1 = "我的巧手可不精通园艺兼饲养",
    GHOST_ORCHID_TRANSITION = "至少它不需要我修理",
    GHOST_ORCHID_STAGE2 = "也许查理喜欢，但是我绝对不行碰它",
    GHOST_ORCHID_STAGE3 = "看看它偷了多少灵感"
})

SafeDescribeGhostOrchid("WARLY", {
    GHOST_ORCHID_SEED = "这颗种子不适合烹饪。",
    GHOST_ORCHID_STAGE1 = "它一定长不出美味的食材",
    GHOST_ORCHID_TRANSITION = "至少闻起来不像是调料",
    GHOST_ORCHID_STAGE2 = "它想越俎代庖！",
    GHOST_ORCHID_STAGE3 = "也许摆在餐桌上当装饰也未尝不可"
})

SafeDescribeGhostOrchid("WORTOX", {
    GHOST_ORCHID_SEED = "小精灵能感觉到这颗种子的特殊能量！",
    GHOST_ORCHID_STAGE1 = "你有着跟我一样的野心",
    GHOST_ORCHID_TRANSITION = "小妖精能感觉到它在变化",
    GHOST_ORCHID_STAGE2 = "你绝对是个窥视狂！",
    GHOST_ORCHID_STAGE3 = "此中恐是兰花处，未许行人著意闻。"
})

SafeDescribeGhostOrchid("WALTER", {
    GHOST_ORCHID_SEED = "沃比说这颗种子很特别！",
    GHOST_ORCHID_STAGE1 = "我得把它记录进日记里",
    GHOST_ORCHID_TRANSITION = "沃比说它在慢慢长大",
    GHOST_ORCHID_STAGE2 = "松树先锋队员无所畏惧",
    GHOST_ORCHID_STAGE3 = "它居然会开花！"
})

SafeDescribeGhostOrchid("WANDA", {
    GHOST_ORCHID_SEED = "这颗种子的时间流动很特别。",
    GHOST_ORCHID_STAGE1 = "它想要用有机物质来加速它的时间循环",
    GHOST_ORCHID_TRANSITION = "时间在它身上流动得异常平稳",
    GHOST_ORCHID_STAGE2 = "我的表针在异常旋转",
    GHOST_ORCHID_STAGE3 = "你浪费了多少时间？"
})

SafeDescribeGhostOrchid("WURT", {
    GHOST_ORCHID_SEED = "这颗种子不适合放在沼泽里。",
    GHOST_ORCHID_STAGE1 = "沼泽也许很适合它",
    GHOST_ORCHID_TRANSITION = "它闻起来不像鱼",
    GHOST_ORCHID_STAGE2 = "别站这么近，浮浪噗！",
    GHOST_ORCHID_STAGE3 = "停止了？"
})

SafeDescribeGhostOrchid("WORMWOOD", {
    GHOST_ORCHID_SEED = "新朋友？",
    GHOST_ORCHID_STAGE1 = "朋友，你好？",
    GHOST_ORCHID_TRANSITION = "朋友在长大",
    GHOST_ORCHID_STAGE2 = "你为什么要吓我？",
    GHOST_ORCHID_STAGE3 = "你在道歉吗？"
})

-- 袅袅的专属对话
SafeDescribeGhostOrchid("niaoniao", {
    GHOST_ORCHID_SEED = "这是我用特殊方法培育的种子...",
    GHOST_ORCHID_STAGE1 = "这个小家伙需要吃点特别的...",
    GHOST_ORCHID_TRANSITION = "它在慢慢长大呢",
    GHOST_ORCHID_STAGE2 = "唔...感觉有点头晕...",
    GHOST_ORCHID_STAGE3 = "这是让我足以安心的能量"
})

-- 创建种子放置器
local ghost_orchid_seed_placer = up:CreateStructurePlacer("ghost_orchid_seed", "entity", "ghost_orchid", "ghost_orchid_idle", {
    snap_to_tile = false,
    snap_to_water = false
})

GLOBAL.Prefabs["ghost_orchid_seed_placer"] = ghost_orchid_seed_placer

-- 添加种子配方
local seed_recipe = AddRecipe2("ghost_orchid_seed", 
    { 
        Ingredient("seeds",1),
        Ingredient("petals_evil", 4)
    },
    TECH.NONE,
    {
        atlas = "images/inventoryimages/ghost_orchid_seed.xml",
        image = "ghost_orchid_seed.tex",
        builder_tag = "niaoniao", -- 限制只有袅袅可以制作
    },
    {"CHARACTER"}
)

seed_recipe.sortkey = 2

-- 为袅袅添加种植标签
AddPlayerPostInit(function(inst)
    if inst.prefab == "niaoniao" then
        inst:AddTag("ghost_orchid_planter")
    end
end)

-- 修复检查系统，正确处理小写的袅袅角色名
AddComponentPostInit("inspectable", function(self)
    local old_GetDescription = self.GetDescription
    self.GetDescription = function(self, viewer)
        local inst = self.inst
        
        if inst.prefab == "ghost_orchid" then
            if not viewer or not viewer.prefab then
                return "神秘的水晶兰"
            end
            
            local viewer_prefab = viewer.prefab
            
            -- 直接使用原始角色名查找字符串表
            local character_strs = GLOBAL.STRINGS.CHARACTERS[viewer_prefab]
            
            -- 如果找不到，尝试使用大写
            if not character_strs or not character_strs.DESCRIBE then
                character_strs = GLOBAL.STRINGS.CHARACTERS[viewer_prefab:upper()]
            end
            
            -- 如果还是找不到，使用通用描述
            if not character_strs or not character_strs.DESCRIBE then
                character_strs = GLOBAL.STRINGS.CHARACTERS.GENERIC
            end
            
            local stage = inst.stage or 1
            local stage_key = ({
                [1] = "GHOST_ORCHID_STAGE1",
                [2] = "GHOST_ORCHID_TRANSITION", 
                [3] = "GHOST_ORCHID_STAGE2",
                [4] = "GHOST_ORCHID_STAGE3"
            })[stage] or "GHOST_ORCHID_STAGE1"
            
            local desc = character_strs.DESCRIBE[stage_key]
            if not desc then
                character_strs = GLOBAL.STRINGS.CHARACTERS.GENERIC
                desc = character_strs.DESCRIBE[stage_key] or "神秘的水晶兰"
            end
            
            return desc
        end
        
        if old_GetDescription then
            return old_GetDescription(self, viewer)
        end
        return nil
    end
end)